// FOGAFIN

var prefijo = "fog-";

// consultamos si hay usuario en el localstorage

var local = {
    data: {
        prefijo: "fog-",
        modulos: { "1": false, "2": false, "3": false, "4": false },
        preguntas: [{
                id: 1,
                pregunta: "¿Qué significa la sigla Fogafín? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Fondo Nacional de Garantías.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Fondo Nacional del Ahorro.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Fondo de Garantías de Instituciones financieras.",
                }]

            },
            {
                id: 2,
                pregunta: "¿A cuál conjunto de instituciones pertenece Fogafín? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Asociación Nacional de Instituciones Financieras.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Federación de aseguradores colombianos.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Red de Seguridad del Sistema Financiero Colombiano.",
                }, {
                    id: 4,
                    type: "text",
                    text: "Asobancaria.",
                }]

            },
            {
                id: 3,
                pregunta: "Las entidades financieras inscritas en Fogafín son: ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Bancos, compañías de financiamiento, fiduciarias, corporaciones financieras y las sociedades especializadas en depósitos y pagos electrónicos.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Bancos, compañías de financiamiento, corporaciones financieras y las sociedades especializadas en depósitos y pagos electrónicos.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Bancos, compañías de financiamiento, fiduciarias, aseguradoras y las sociedades especializadas en depósitos y pagos electrónicos.",
                }, {
                    id: 4,
                    type: "text",
                    text: "Ninguna de las anteriores.",
                }]

            },
            {
                id: 4,
                pregunta: "¿Cómo está conformada la Junta Directiva de Fogafín? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Ministro de Hacienda y Crédito Público, Gerente general del Banco de la República, Superintendente Financiero y un delegado de Asobancaria.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Ministro de Hacienda y Crédito Público, Gerente del Banco de la República, Superintendente Financiero y Director de Fogafín.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Ministro de Hacienda y Crédito Público, Gerente general del Banco de la República, Superintendente Financiero y dos delegados del Presidente de la República.",
                }]

            },
            {
                id: 5,
                pregunta: "¿Cuál es la entidad encargada de pagar el Seguro de Depósitos?",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Fondo Nacional de Garantías.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Fondo de Garantías de Instituciones Financieras.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Fondo de Garantías.",
                }]

            },
            {
                id: 6,
                pregunta: "¿Qué es el Seguro de Depósitos? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Es el seguro que permite proteger a los ahorradores de las entidades inscritas en Fogafín en caso de un fraude bancario. ",
                }, {
                    id: 2,
                    type: "text",
                    text: "Es el mecanismo que protege a los ahorradores de las entidades inscritas en Fogafín que son liquidadas.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Es el seguro de desempleo que cubre a los ahorradores colombianos.",
                }]

            },
            {
                id: 7,
                pregunta: "¿En qué caso aplica el pago del Seguro de Depósitos?  ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Cuando no se pueda pagar una obligación bancaria con una de las entidades inscritas en Fogafín.",
                }, {
                    id: 2,
                    type: "text",
                    text: "En caso de clonación de la tarjeta débito de una entidad inscrita en Fogafín.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Ante la liquidación de una entidad inscrita en Fogafín.",
                }]

            },
            {
                id: 8,
                pregunta: "¿Cuál es la cobertura del Seguro de Depósitos de Fogafín? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "$20.000.000",
                }, {
                    id: 2,
                    type: "text",
                    text: "$50.000.000",
                }, {
                    id: 3,
                    type: "text",
                    text: "$25.000.000",
                }]

            },
            {
                id: 9,
                pregunta: "¿Qué costo tiene para el ahorrador el Seguro de Depósitos? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "El 0.5% del dinero que se encuentran en el producto de ahorro.",
                }, {
                    id: 2,
                    type: "text",
                    text: "El 1% del dinero que se encuentran en el producto de ahorro.",
                }, {
                    id: 3,
                    type: "text",
                    text: "No debe pagar nada.",
                }]

            },
            {
                id: 10,
                pregunta: "¿Cómo se financia el Seguro de Depósitos de Fogafín? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Por medio de las primas que pagan los clientes.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Por medio de las primas que paga el Estado.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Por medio de las primas que pagan las entidades inscritas.",
                }]

            },
            {
                id: 11,
                pregunta: "¿Cuáles de estos productos están protegidos por el Seguro de Depósitos de Fogafín? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Depósitos  en  cuenta  corriente,  depósitos  simples,  Certificados  de Depósitos a Término -CDT, depósitos de ahorro, cuentas de ahorro especial. ",
                }, {
                    id: 2,
                    type: "text",
                    text: "Bonos  hipotecarios,  depósitos  especiales,  servicios  bancarios  de recaudo, depósitos de bajo monto y depósitos ordinarios. ",
                }, {
                    id: 3,
                    type: "text",
                    text: "Productos fiduciarios, seguros y bonos ordinarios.",
                }, {
                    id: 4,
                    type: "text",
                    text: "A y B son correctas.",
                }]

            },
            {
                id: 12,
                pregunta: "¿Cómo saber si el producto de ahorro está protegido por el Seguro de Depósitos? ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Encontrando el sello del Seguro de Depósitos en el extracto del producto.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Preguntando al asesor de la entidad en donde tiene el producto.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Buscando en la página web de la entidad en donde tiene el producto de ahorro.",
                }, {
                    id: 4,
                    type: "text",
                    text: "Todas las anteriores.",
                }]

            },
            {
                id: 13,
                pregunta: "¿Cuál es el sello con el que puedo identificar si el producto que tengo en una entidad financiera está protegido por el Seguro de Depósitos? ",
                respuestas: [{
                    id: 1,
                    type: "image",
                    // url: "Poner la imagen del sello del Seguro de depósitos, pero haciendo algún cambio en el contenido",
                    url: "images/logo02.png",
                }, {
                    id: 2,
                    type: "image",
                    // url: "Imagen correcta del sello",
                    url: "images/logo03.png",
                }, {
                    id: 3,
                    type: "image",
                    // url: "Logo de Fogafín",
                    url: "images/logo01.png",
                }]

            },
            {
                id: 14,
                pregunta: "Si una persona tiene en un producto de ahorro 70 millones de pesos y la entidad inscrita en Fogafín entra en liquidación ¿cuánto recibiría el depositante por el Seguro de Depósitos?",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Recibiría la totalidad del dinero. ",
                }, {
                    id: 2,
                    type: "text",
                    text: "Recibiría 50 millones de pesos y el dinero restante deberá reclamarlo ante el proceso liquidatorio.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Debería solicitar el pago de los 70 millones de pesos ante el proceso liquidatorio.",
                }]

            },
            {
                id: 15,
                pregunta: "Cuando  dos  o  más  personas  son  titulares  de un  producto  amparado  y  la entidad  se  liquida,  Fogafín  pagará  el  Seguro  de  Depósitos  de  la  siguiente manera: ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Por partes iguales a cada uno de los titulares.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Solo a uno de los titulares.",
                }, {
                    id: 3,
                    type: "text",
                    text: "Se le paga la totalidad al primero que llegue.",
                }, {
                    id: 4,
                    type: "text",
                    text: "A y C son correctas.",
                }]

            },
            {
                id: 16,
                pregunta: "¿El Seguro de Depósitos protege productos de crédito?: ",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "Sí.",
                }, {
                    id: 2,
                    type: "text",
                    text: "No.",
                }]

            },
            {
                id: 17,
                pregunta: "Si una persona tiene una cuenta de ahorros y una fiducia en una entidad inscrita en Fogafín, y esta entra en liquidación, ¿el Seguro de Depósitos le responde por el dinero que tiene en qué producto?",
                respuestas: [{
                    id: 1,
                    type: "text",
                    text: "En ambas.",
                }, {
                    id: 2,
                    type: "text",
                    text: "Solo en fiducia. ",
                }, {
                    id: 3,
                    type: "text",
                    text: "En la cuenta de ahorros. ",
                }, {
                    id: 4,
                    type: "text",
                    text: "Ninguna de las anteriores. ",
                }]

            }
        ],
        respuestas: [
            { pregunta: 1, respuesta: 3 },
            { pregunta: 2, respuesta: 3 },
            { pregunta: 3, respuesta: 2 },
            { pregunta: 4, respuesta: 3 },
            { pregunta: 5, respuesta: 2 },
            { pregunta: 6, respuesta: 2 },
            { pregunta: 7, respuesta: 3 },
            { pregunta: 8, respuesta: 2 },
            { pregunta: 9, respuesta: 3 },
            { pregunta: 10, respuesta: 3 },
            { pregunta: 11, respuesta: 4 },
            { pregunta: 12, respuesta: 4 },
            { pregunta: 13, respuesta: 3 },
            { pregunta: 14, respuesta: 2 },
            { pregunta: 15, respuesta: 1 },
            { pregunta: 16, respuesta: 2 },
            { pregunta: 17, respuesta: 3 },
        ],
    },
    getItem: function(key) {
        return localStorage.getItem(local.data.prefijo + key);
    },
    setItem: function(key, value) {
        localStorage.setItem(local.data.prefijo + key, value);
    },
    setNickname: function(value) {
        var oldItems = JSON.parse(local.getItem('users')) || [];
        var user = oldItems.filter(item => item.nickname == value);

        // si el usuario no existe
        if (user.length == 0) {
            var newItem = { "nickname": value, "modulos": local.data.modulos };
            oldItems.push(newItem);
            local.setItem('users', JSON.stringify(oldItems));
        }

        local.setItem('current-user', value);
    },
    getNickname: function() {
        return local.getItem('current-user');
    },
    setModuloCompleto: function(value) {
        var modulosOld = {};
        var finalItems = [];
        var oldItems = JSON.parse(local.getItem('users')) || [];
        var nickname = local.getNickname();
        oldItems.map((v, k) => {
            modulosOld = v.modulos;
            if (v.nickname == nickname) {
                modulosOld[value] = true;
            }
            // construimos de nuevo el objeto final
            var newItem = { "nickname": v.nickname, "modulos": modulosOld };
            finalItems.push(newItem);
        });
        local.setItem('users', JSON.stringify(oldItems));
    },
    validarModulos: function() {
        var valid = true;
        var oldItems = JSON.parse(local.getItem('users')) || [];
        var user = oldItems.filter(item => item.nickname == local.getNickname());
        if (user[0]) {
            var modulos = user[0].modulos;
            keys = Object.keys(modulos);

            keys.forEach((k) => {
                if ((modulos[k] == null || modulos[k] == false || modulos[k] == "false") && valid) {
                    valid = false;
                }
            })
        }
        return valid;
    },
    getUrlImageMap: function() {
        var name = "";
        var oldItems = JSON.parse(local.getItem('users')) || [];
        var user = oldItems.filter(item => item.nickname == local.getNickname());
        if (user[0]) {
            var modulos = user[0].modulos;
            keys = Object.keys(modulos);

            keys.forEach((k) => {
                if (modulos[k] == true || modulos[k] == "true") {
                    if (name.length == 0) {
                        name = k;
                    } else {
                        name = name + "-" + k;
                    }
                }

            })
        }

        if (name.length == "") {
            return "./images/navs/Interaccion-01-safe.png";
        }
        return "./images/navs/aprueba/Estados-" + name + ".png";
    },
    getPreguntas: function() {
        var min = 1; // rango inicial
        var max = 17; // rango final
        var cant = 5; // cantidad de preguntas
        var consultar = true;
        var usados = [];
        var ok = 0;
        while (consultar) {
            var num = Math.floor(Math.random() * (max - min + 1)) + min;
            if (!usados.some((e) => e == num)) {
                usados.push(num);
                ok++;
                if (cant == ok) {
                    consultar = false;
                }
            }
        }
        // usados.push(13);
        let preguntas = local.data.preguntas;
        return preguntas.filter(item => usados.includes(item.id));
    },
    validarRespuesta: (pregunta, respuesta) => {
        let resp = local.data.respuestas.filter(item => item.pregunta == pregunta);
        return parseInt(resp[0].respuesta);
    },
    getAllSession() {
        var archive = {}, // Notice change here
            keys = Object.keys(localStorage),
            i = keys.length;

        while (i--) {
            if (keys[i].search('fog-') >= 0) {
                archive[keys[i]] = localStorage.getItem(keys[i]);
            }
        }

        return archive;
    },
    cerrarSession() {
        // let storage = local.getAllSession();

        // Object.keys(storage).forEach(key => {
        //     localStorage.removeItem(key);
        // });
        localStorage.removeItem(local.data.prefijo + 'current-user');

        // temporal
        Object.keys(local.data.modulos).forEach(key => {
            localStorage.removeItem(local.data.prefijo + 'modulo-' + key);
        });
    }
}